# This file allows users to call find_package(MLIR) and pick up our targets.

# Compute the installation prefix from this LLVMConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

find_package(LLVM REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "MLIRAnalysis;MLIRPresburger;MLIRAsmParser;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithmeticToLLVM;MLIRArithmeticToSPIRV;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLLVM;MLIRComplexToLibm;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSPIRV;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRNVGPUToNVVM;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToTensor;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRArithmeticDialect;MLIRArithmeticTransforms;MLIRArithmeticUtils;MLIRArmNeonDialect;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRAMXDialect;MLIRAMXTransforms;MLIRBufferizationDialect;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRDLTIDialect;MLIREmitCDialect;MLIRFuncDialect;MLIRFuncTransforms;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRMLProgramDialect;MLIRNVGPUDialect;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorDialect;MLIRSparseTensorTransforms;MLIRSparseTensorPipelines;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaTransforms;MLIRTransformDialect;MLIRTransformDialectTransforms;MLIRDialectUtils;MLIRVectorDialect;MLIRVectorTransforms;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRParallelCombiningOpInterface;MLIRSideEffectInterfaces;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRLoopLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRReduceLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIRTestAnalysis;MLIRTestFuncToLLVM;MLIRAffineTransformsTestPasses;MLIRDLTITestPasses;MLIRFuncTestPasses;MLIRGPUTestPasses;MLIRLinalgTestPasses;MLIRMathTestPasses;MLIRMemRefTestPasses;MLIRSCFTestPasses;MLIRShapeTestPasses;MLIRSPIRVTestPasses;MLIRTensorTestPasses;MLIRTestDialect;MLIRTosaTestPasses;MLIRTestTransformDialect;MLIRVectorTestPasses;MLIRTilingInterfaceTestPasses;MLIRTestIR;MLIRTestPass;MLIRTestReducer;MLIRTestRewrite;MLIRTestPDLL;MLIRTestTransforms;MLIRMlirOptMain")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")
set(MLIR_PDLL_TABLEGEN_EXE "mlir-pdll")
set(MLIR_INSTALL_AGGREGATE_OBJECTS "1")
set(MLIR_ENABLE_BINDINGS_PYTHON "0")

# For mlir_tablegen()
set(MLIR_INCLUDE_DIR "/home/tcwg-buildslave/workspace/tcwg-llvm-release/tcwg-jade-03/final/Phase3/Release/llvmCore-15.0.6-final.obj/tools/mlir/include")
set(MLIR_MAIN_SRC_DIR "/home/tcwg-buildslave/workspace/tcwg-llvm-release/tcwg-jade-03/final/llvm-project/mlir")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRAnalysis;MLIRPresburger;MLIRAsmParser;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithmeticToLLVM;MLIRArithmeticToSPIRV;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLLVM;MLIRComplexToLibm;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSPIRV;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRNVGPUToNVVM;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToTensor;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRArithmeticDialect;MLIRArithmeticTransforms;MLIRArithmeticUtils;MLIRArmNeonDialect;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRAMXDialect;MLIRAMXTransforms;MLIRBufferizationDialect;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRDLTIDialect;MLIREmitCDialect;MLIRFuncDialect;MLIRFuncTransforms;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRMLProgramDialect;MLIRNVGPUDialect;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorDialect;MLIRSparseTensorTransforms;MLIRSparseTensorPipelines;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaTransforms;MLIRTransformDialect;MLIRTransformDialectTransforms;MLIRDialectUtils;MLIRVectorDialect;MLIRVectorTransforms;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRParallelCombiningOpInterface;MLIRSideEffectInterfaces;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRLoopLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRReduceLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIRTestAnalysis;MLIRTestFuncToLLVM;MLIRAffineTransformsTestPasses;MLIRDLTITestPasses;MLIRFuncTestPasses;MLIRGPUTestPasses;MLIRLinalgTestPasses;MLIRMathTestPasses;MLIRMemRefTestPasses;MLIRSCFTestPasses;MLIRShapeTestPasses;MLIRSPIRVTestPasses;MLIRTensorTestPasses;MLIRTestDialect;MLIRTosaTestPasses;MLIRTestTransformDialect;MLIRVectorTestPasses;MLIRTilingInterfaceTestPasses;MLIRTestIR;MLIRTestPass;MLIRTestReducer;MLIRTestRewrite;MLIRTestPDLL;MLIRTestTransforms;MLIRMlirOptMain")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRArithmeticDialect;MLIRArithmeticTransforms;MLIRArithmeticUtils;MLIRArmNeonDialect;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRAMXDialect;MLIRAMXTransforms;MLIRBufferizationDialect;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRDLTIDialect;MLIREmitCDialect;MLIRFuncDialect;MLIRFuncTransforms;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRMLProgramDialect;MLIRNVGPUDialect;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSparseTensorDialect;MLIRSparseTensorTransforms;MLIRSparseTensorPipelines;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaTransforms;MLIRTransformDialect;MLIRTransformDialectTransforms;MLIRVectorDialect;MLIRVectorTransforms;MLIRVectorUtils;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRTosaTestPasses")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithmeticToLLVM;MLIRArithmeticToSPIRV;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexToLLVM;MLIRComplexToLibm;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSPIRV;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToSPIRV;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRNVGPUToNVVM;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToTensor;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRTargetCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport")

# Provide all our library targets to users.
# More specifically, configure MLIR so that it can be directly included in a top
# level CMakeLists.txt, but also so that it can be imported via `find_package`.
# This is based on how LLVM handles exports.
if(NOT TARGET MLIRSupport)
  include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")
endif()

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
